/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import noppes.npcs.reflection.nbt.NBTTagListReflection;
import noppes.npcs.util.Util;

public class NBTJsonUtil {
    public static String Convert(NBTTagCompound compound) {
        ArrayList<JsonLine> list = new ArrayList<JsonLine>();
        JsonLine line = NBTJsonUtil.ReadTag("", (NBTBase)compound, list);
        line.removeComma();
        return NBTJsonUtil.ConvertList(list);
    }

    public static NBTTagCompound Convert(String json) throws JsonException {
        String newJson = json.trim();
        JsonFile file = new JsonFile(newJson);
        if (!newJson.startsWith("{") || !newJson.endsWith("}")) {
            throw new JsonException("Not properly incapsulated between { }", file);
        }
        NBTTagCompound compound = new NBTTagCompound();
        NBTJsonUtil.FillCompound(compound, file);
        return compound;
    }

    private static String ConvertList(List<JsonLine> list) {
        StringBuilder json = new StringBuilder();
        int tab = 0;
        for (JsonLine tag : list) {
            if (tag.reduceTab()) {
                --tab;
            }
            for (int i = 0; i < tab; ++i) {
                json.append("\t");
            }
            json.append(tag).append("\n");
            if (!tag.increaseTab()) continue;
            ++tab;
        }
        return json.toString();
    }

    public static void FillCompound(NBTTagCompound compound, JsonFile json) throws JsonException {
        if (json.startsWith("{") || json.startsWith(",")) {
            json.cut(1);
        }
        if (json.startsWith("}")) {
            return;
        }
        int index = json.keyIndex();
        if (index < 1) {
            throw new JsonException("Expected key after ,", json);
        }
        String key = json.substring(0, index);
        json.cut(index + 1);
        NBTBase base = NBTJsonUtil.ReadValue(json);
        if (key.startsWith("\"")) {
            key = key.substring(1);
        }
        if (key.endsWith("\"")) {
            key = key.substring(0, key.length() - 1);
        }
        if (base != null) {
            compound.func_74782_a(key, base);
        }
        if (json.startsWith(",")) {
            NBTJsonUtil.FillCompound(compound, json);
        }
    }

    private static List<NBTBase> getListData(NBTTagList list) {
        return NBTTagListReflection.getTagList(list);
    }

    public static NBTTagCompound LoadFile(File file) throws IOException, JsonException {
        return NBTJsonUtil.Convert(Util.instance.loadFile(file));
    }

    public static void main(String[] args) {
        NBTTagCompound comp = new NBTTagCompound();
        NBTTagCompound comp2 = new NBTTagCompound();
        comp2.func_74773_a("test", new byte[]{0, 0, 1, 1, 0});
        comp.func_74782_a("comp", (NBTBase)comp2);
    }

    private static JsonLine ReadTag(String name, NBTBase base, List<JsonLine> list) {
        JsonLine jsonLine;
        JsonLine line;
        if (!name.isEmpty()) {
            name = "\"" + name + "\": ";
        }
        if (base.func_74732_a() == 9) {
            list.add(new JsonLine(name + "["));
            NBTTagList tags = (NBTTagList)base;
            line = null;
            List<NBTBase> data = NBTJsonUtil.getListData(tags);
            for (NBTBase b : data) {
                line = NBTJsonUtil.ReadTag("", b, list);
            }
            if (line != null) {
                line.removeComma();
            }
            list.add(new JsonLine("]"));
        } else if (base.func_74732_a() == 10) {
            list.add(new JsonLine(name + "{"));
            NBTTagCompound compound = (NBTTagCompound)base;
            line = null;
            for (Object key : compound.func_150296_c()) {
                line = NBTJsonUtil.ReadTag(key.toString(), compound.func_74781_a(key.toString()), list);
            }
            if (line != null) {
                line.removeComma();
            }
            list.add(new JsonLine("}"));
        } else if (base.func_74732_a() == 11) {
            list.add(new JsonLine(name + base.toString().replaceFirst(",]", "]")));
        } else {
            list.add(new JsonLine(name + base));
        }
        JsonLine line2 = jsonLine = list.get(list.size() - 1);
        JsonLine jsonLine2 = jsonLine;
        jsonLine2.line = jsonLine2.line + ",";
        return line2;
    }

    public static NBTBase ReadValue(JsonFile json) throws JsonException {
        if (json.startsWith("{")) {
            NBTTagCompound compound = new NBTTagCompound();
            NBTJsonUtil.FillCompound(compound, json);
            if (!json.startsWith("}")) {
                throw new JsonException("Expected }", json);
            }
            json.cut(1);
            return compound;
        }
        if (json.startsWith("[")) {
            json.cut(1);
            NBTTagList list = new NBTTagList();
            if (json.startsWith("B;") || json.startsWith("I;") || json.startsWith("L;")) {
                json.cut(2);
            }
            NBTBase value = NBTJsonUtil.ReadValue(json);
            while (value != null) {
                list.func_74742_a(value);
                if (!json.startsWith(",")) break;
                json.cut(1);
                value = NBTJsonUtil.ReadValue(json);
            }
            if (!json.startsWith("]")) {
                throw new JsonException("Expected ]", json);
            }
            json.cut(1);
            if (list.func_150303_d() == 3) {
                int[] arr = new int[list.func_74745_c()];
                int i = 0;
                while (list.func_74745_c() > 0) {
                    arr[i] = ((NBTTagInt)list.func_74744_a(0)).func_150287_d();
                    ++i;
                }
                return new NBTTagIntArray(arr);
            }
            if (list.func_150303_d() == 1) {
                byte[] arr2 = new byte[list.func_74745_c()];
                int i = 0;
                while (list.func_74745_c() > 0) {
                    arr2[i] = ((NBTTagByte)list.func_74744_a(0)).func_150290_f();
                    ++i;
                }
                return new NBTTagByteArray(arr2);
            }
            if (list.func_150303_d() == 4) {
                long[] arr3 = new long[list.func_74745_c()];
                int i = 0;
                while (list.func_74745_c() > 0) {
                    arr3[i] = ((NBTTagLong)list.func_74744_a(0)).func_150290_f();
                    ++i;
                }
                return new NBTTagLongArray(arr3);
            }
            return list;
        }
        if (json.startsWith("\"")) {
            json.cut(1);
            String s = "";
            String cut = "";
            boolean ignore = false;
            while (!json.startsWith("\"") || ignore) {
                cut = json.cutDirty(1);
                ignore = cut.equals("\\");
                s = s + cut;
            }
            json.cut(1);
            return new NBTTagString(s.replace("\\\\", "\\").replace("\\\"", "\""));
        }
        StringBuilder s = new StringBuilder();
        while (!json.startsWith(",", "]", "}")) {
            s.append(json.cut(1));
        }
        if ((s = new StringBuilder(s.toString().trim().toLowerCase())).length() == 0 || s.toString().contains("bytes]")) {
            return null;
        }
        try {
            if (s.toString().endsWith("d")) {
                return new NBTTagDouble(Double.parseDouble(s.substring(0, s.length() - 1)));
            }
            if (s.toString().endsWith("f")) {
                return new NBTTagFloat(Float.parseFloat(s.substring(0, s.length() - 1)));
            }
            if (s.toString().endsWith("b")) {
                return new NBTTagByte(Byte.parseByte(s.substring(0, s.length() - 1)));
            }
            if (s.toString().endsWith("s")) {
                return new NBTTagShort(Short.parseShort(s.substring(0, s.length() - 1)));
            }
            if (s.toString().endsWith("l")) {
                return new NBTTagLong(Long.parseLong(s.substring(0, s.length() - 1)));
            }
            if (s.toString().contains(".")) {
                return new NBTTagDouble(Double.parseDouble(s.toString()));
            }
            return new NBTTagInt(Integer.parseInt(s.toString()));
        }
        catch (NumberFormatException ex) {
            throw new JsonException("Unable to convert: " + s + " to a number", json);
        }
    }

    static class JsonLine {
        private String line;

        public JsonLine(String line) {
            this.line = line;
        }

        public boolean increaseTab() {
            return this.line.endsWith("{") || this.line.endsWith("[");
        }

        public boolean reduceTab() {
            int length = this.line.length();
            return length == 1 && (this.line.endsWith("}") || this.line.endsWith("]")) || length == 2 && (this.line.endsWith("},") || this.line.endsWith("],"));
        }

        public void removeComma() {
            if (this.line.endsWith(",")) {
                this.line = this.line.substring(0, this.line.length() - 1);
            }
        }

        public String toString() {
            return this.line;
        }
    }

    public static class JsonFile {
        private final String original;
        private String text;

        public JsonFile(String text) {
            this.text = text;
            this.original = text;
        }

        public String cut(int i) {
            String s = this.text.substring(0, i);
            this.text = this.text.substring(i).trim();
            return s;
        }

        public String cutDirty(int i) {
            String s = this.text.substring(0, i);
            this.text = this.text.substring(i);
            return s;
        }

        public boolean endsWith(String s) {
            return this.text.endsWith(s);
        }

        public String getCurrentPos() {
            int lengthOr = this.original.length();
            int lengthCur = this.text.length();
            int currentPos = lengthOr - lengthCur;
            String done = this.original.substring(0, currentPos);
            String[] lines = done.split("\r\n|\r|\n");
            int pos = 0;
            String line = "";
            if (lines.length > 0) {
                pos = lines[lines.length - 1].length();
                line = this.original.split("\r\n|\r|\n")[lines.length - 1].trim();
            }
            return "Line: " + lines.length + ", Pos: " + pos + ", Text: " + line;
        }

        public int indexOf(String s) {
            return this.text.indexOf(s);
        }

        public int keyIndex() {
            boolean hasQuote = false;
            for (int i = 0; i < this.text.length(); ++i) {
                char c = this.text.charAt(i);
                if (i == 0 && c == '\"') {
                    hasQuote = true;
                } else if (hasQuote && c == '\"') {
                    hasQuote = false;
                }
                if (hasQuote || c != ':') continue;
                return i;
            }
            return -1;
        }

        public boolean startsWith(String ... ss) {
            for (String s : ss) {
                if (!this.text.startsWith(s)) continue;
                return true;
            }
            return false;
        }

        public String substring(int beginIndex, int endIndex) {
            return this.text.substring(beginIndex, endIndex);
        }
    }

    public static class JsonException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public JsonException(String message, JsonFile json) {
            super(message + ": " + json.getCurrentPos());
        }
    }
}

